/*  Copyright (C) 2015-2017  Povilas Kanapickas <povilas@radix.lt>

    Distributed under the Boost Software License, Version 1.0.
        (See accompanying file LICENSE_1_0.txt or copy at
            http://www.boost.org/LICENSE_1_0.txt)
*/

#ifndef LIBSIMDPP_SIMDPP_DETAIL_INSN_ID_H
#define LIBSIMDPP_SIMDPP_DETAIL_INSN_ID_H

// Instruction set ids used when constructing architecture id. The architecture
// id is then used to define SIMDPP_ARCH_NAMESPACE
#define SIMDPP_INSN_ID_NULL _null
#define SIMDPP_INSN_ID_SSE2 _sse2
#define SIMDPP_INSN_ID_SSE3 _sse3
#define SIMDPP_INSN_ID_SSSE3 _ssse3
#define SIMDPP_INSN_ID_SSE4_1 _sse4p1
#define SIMDPP_INSN_ID_POPCNT_INSN _popcnt
#define SIMDPP_INSN_ID_AVX _avx
#define SIMDPP_INSN_ID_AVX2 _avx2
#define SIMDPP_INSN_ID_FMA3 _fma3
#define SIMDPP_INSN_ID_FMA4 _fma4
#define SIMDPP_INSN_ID_XOP _xop
#define SIMDPP_INSN_ID_AVX512F _avx512f
#define SIMDPP_INSN_ID_AVX512BW _avx512bw
#define SIMDPP_INSN_ID_AVX512DQ _avx512dq
#define SIMDPP_INSN_ID_AVX512VL _avx512vl
#define SIMDPP_INSN_ID_NEON _neon
#define SIMDPP_INSN_ID_NEON_FLT_SP _neonfltsp
#define SIMDPP_INSN_ID_ALTIVEC _altivec
#define SIMDPP_INSN_ID_VSX_206 _vsx_206
#define SIMDPP_INSN_ID_VSX_207 _vsx_207
#define SIMDPP_INSN_ID_MSA _msa

// Arbitrary masks used to simplify architecture processing
// (used in preprocess_single_arch.h)
#define SIMDPP_INSN_MASK_NULL        0x00000001
#define SIMDPP_INSN_MASK_SSE2        0x00000002
#define SIMDPP_INSN_MASK_SSE3        0x00000004
#define SIMDPP_INSN_MASK_SSSE3       0x00000008
#define SIMDPP_INSN_MASK_SSE4_1      0x00000010
#define SIMDPP_INSN_MASK_POPCNT_INSN 0x00000020
#define SIMDPP_INSN_MASK_AVX         0x00000040
#define SIMDPP_INSN_MASK_AVX2        0x00000080
#define SIMDPP_INSN_MASK_FMA3        0x00000100
#define SIMDPP_INSN_MASK_FMA4        0x00000200
#define SIMDPP_INSN_MASK_XOP         0x00000400
#define SIMDPP_INSN_MASK_AVX512F     0x00000800
#define SIMDPP_INSN_MASK_AVX512BW    0x00001000
#define SIMDPP_INSN_MASK_AVX512DQ    0x00002000
#define SIMDPP_INSN_MASK_AVX512VL    0x00004000
#define SIMDPP_INSN_MASK_NEON        0x00008000
#define SIMDPP_INSN_MASK_NEON_FLT_SP 0x00010000
#define SIMDPP_INSN_MASK_ALTIVEC     0x00020000
#define SIMDPP_INSN_MASK_VSX_206     0x00040000
#define SIMDPP_INSN_MASK_VSX_207     0x00080000
#define SIMDPP_INSN_MASK_MSA         0x00100000

#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_NULL        SIMDPP_INSN_MASK_NULL
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_SSE2        SIMDPP_INSN_MASK_SSE2
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_SSE3        SIMDPP_INSN_MASK_SSE3
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_SSSE3       SIMDPP_INSN_MASK_SSSE3
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_SSE4_1      SIMDPP_INSN_MASK_SSE4_1
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_POPCNT_INSN SIMDPP_INSN_MASK_POPCNT_INSN
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_AVX         SIMDPP_INSN_MASK_AVX
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_AVX2        SIMDPP_INSN_MASK_AVX2
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_FMA3        SIMDPP_INSN_MASK_FMA3
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_FMA4        SIMDPP_INSN_MASK_FMA4
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_XOP         SIMDPP_INSN_MASK_XOP
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_AVX512F     SIMDPP_INSN_MASK_AVX512F
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_AVX512BW    SIMDPP_INSN_MASK_AVX512BW
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_AVX512DQ    SIMDPP_INSN_MASK_AVX512DQ
#define SIMDPP_PREFIX_SIMDPP_ARCH_X86_AVX512VL    SIMDPP_INSN_MASK_AVX512VL
#define SIMDPP_PREFIX_SIMDPP_ARCH_ARM_NEON        SIMDPP_INSN_MASK_NEON
#define SIMDPP_PREFIX_SIMDPP_ARCH_ARM_NEON_FLT_SP SIMDPP_INSN_MASK_NEON_FLT_SP
#define SIMDPP_PREFIX_SIMDPP_ARCH_POWER_ALTIVEC   SIMDPP_INSN_MASK_ALTIVEC
#define SIMDPP_PREFIX_SIMDPP_ARCH_POWER_VSX_206   SIMDPP_INSN_MASK_VSX_206
#define SIMDPP_PREFIX_SIMDPP_ARCH_POWER_VSX_207   SIMDPP_INSN_MASK_VSX_207
#define SIMDPP_PREFIX_SIMDPP_ARCH_MIPS_MSA        SIMDPP_INSN_MASK_MSA

#endif

